Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      create_queues.sql - Creates queues used for this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates queue MGW_LCR_SRC and MGW_LCR_DEST with 
Rem      payload of type SYS.ANYDATA.
Rem
Rem    NOTES
Rem      This script assumes that create_users.sql has already been run.
Rem
Rem

connect mgwuser/mgwuser
set serveroutput on

-- create queue tables and queues
begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_lcr_mc',
                   queue_payload_type => 'sys.anydata',
                   multiple_consumers => TRUE);

    dbms_aqadm.create_queue(queue_name =>'mgw_lcr_src',
                            queue_table => 'mgw_lcr_mc',
                            max_retries => 1000);

    dbms_aqadm.start_queue('mgw_lcr_src');


    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_lcr_sc',
                   queue_payload_type => 'sys.anydata',
                   multiple_consumers => FALSE);

    dbms_aqadm.create_queue(queue_name =>'mgw_lcr_dest',
                            queue_table => 'mgw_lcr_sc',
                            max_retries => 1000);

    dbms_aqadm.start_queue('mgw_lcr_dest');
end;
/

